﻿/* Copyright 2015 Intellica Corporation 
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at
    http://www.apache.org/licenses/LICENSE-2.0
Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Newtonsoft.Json;
using Ext.Net;
using System.IO;
using System.Data;
using DataAccess;


/// <summary>
/// Ext utilities class for dealing with ext js controls
/// </summary>
public static class CExtUtils
{
	/// <summary>
    /// US:5859 loads an ext combo from dataset
    /// </summary>
    /// <param name="cbo"></param>
    /// <param name="ds"></param>
    /// <param name="strValueField"></param>
    /// <param name="strDisplayField"></param>
    public static void LoadEXTCombo(Ext.Net.ComboBox cbo,
                                    DataSet ds,
                                    string strValueField,
                                    string strDisplayField)
    {
        if (ds == null)
        {
            return;
        }

        foreach (DataTable dt in ds.Tables)
        {
            foreach (DataRow row in dt.Rows)
            {
                string strValue = CDataUtils2.GetDSStringValue(row, strValueField);
                string strDisplay = CDataUtils2.GetDSStringValue(row, strDisplayField);
                cbo.Items.Add(new Ext.Net.ListItem(HttpUtility.HtmlDecode(CDataUtils2.Sanitize(strDisplay)),
                                                   HttpUtility.HtmlDecode(CDataUtils2.Sanitize(strValue))));
            }
        }
    }

    /*
    public static void LoadEXTCombo(Ext.Net.ComboBox cbo,
                                    DataSet ds,
                                    string strValueField,
                                    string strDisplayField)
    {
        if (ds == null)
        {
            return;
        }

        foreach (DataTable dt in ds.Tables)
        {
            foreach (DataRow row in dt.Rows)
            {
                string strValue = CDataUtils2.GetDSStringValue(row, strValueField);
                string strDisplay = CDataUtils2.GetDSStringValue(row, strDisplayField);
                cbo.Items.Add(new Ext.Net.ListItem(CDataUtils2.Sanitize(strDisplay),
                                                   CDataUtils2.Sanitize(strValue)));
            }
        }
    }
     */

    /// <summary>
    /// US:5859 loads an ext radiogroup list from dataset
    /// </summary>
    /// <param name="rgroup"></param>
    /// <param name="ds"></param>
    /// <param name="strValueField"></param>
    /// <param name="strDisplayField"></param>
    public static void LoadExtRadioGroup(Ext.Net.RadioGroup rgroup,
                                         DataSet ds,
                                         string strValueField,
                                         string strDisplayField)
    {
        if (ds == null)
        {
            return;
        }

        foreach (DataTable dt in ds.Tables)
        {
            foreach (DataRow row in dt.Rows)
            {
                string strValue = CDataUtils2.GetDSStringValue(row, strValueField);
                string strDisplay = CDataUtils2.GetDSStringValue(row, strDisplayField);

                Ext.Net.Radio r = new Ext.Net.Radio();
                r.Value = strValue;
                r.ID = rgroup.ID + "_" + strValue;
                r.BoxLabel = strDisplay;

                rgroup.Items.Add(r);
            }
        }
    }

    /// <summary>
    ///  US:5859 loads an ext checkboxgroup list from dataset
    /// </summary>
    /// <param name="chkgroup"></param>
    /// <param name="ds"></param>
    /// <param name="strValueField"></param>
    /// <param name="strDisplayField"></param>
    public static void LoadExtCheckboxGroup(Ext.Net.CheckboxGroup chkgroup,
                                         DataSet ds,
                                         string strValueField,
                                         string strDisplayField)
    {
        if (ds == null)
        {
            return;
        }

        foreach (DataTable dt in ds.Tables)
        {
            foreach (DataRow row in dt.Rows)
            {
                string strValue = CDataUtils2.GetDSStringValue(row, strValueField);
                string strDisplay = CDataUtils2.GetDSStringValue(row, strDisplayField);

                Ext.Net.Checkbox c = new Ext.Net.Checkbox();
                c.InputValue = strValue;
                c.BoxLabel = strDisplay;

                chkgroup.Items.Add(c);
            }
        }
    }
}